#ifndef DATABASE_MESSAGE_H
#define DATABASE_MESSAGE_H

#include "Message.h"
#include <Message.h>

#define DBMSG_API_VERSION	1

// Class supporting messages sent to the Database through the BLooper construct
// (not port-based messages).

// Modified, CGP, 10/12/00, Now storing performance data.

// Message types
enum {
	// File I/O
	DBMSG_SAVE,
	DBMSG_LOAD,
	
	// Settings
	DBMSG_GET_RAT_SETTINGS,
	DBMSG_SET_RAT_SETTINGS,
	DBMSG_GET_EXPERIMENTER_SETTINGS,
	DBMSG_SET_EXPERIMENTER_SETTINGS,
	DBMSG_GET_PERF_MON_SETTINGS,
	DBMSG_SET_PERF_MON_SETTINGS,
	DBMSG_GET_PLUGIN_NAME,
	DBMSG_SET_PLUGIN_NAME,
	
	// Performance data
	DBMSG_ADD_RECORD,
	DBMSG_GET_NUMBER_OF_RECORDS,
	DBMSG_GET_CURRENT_RAT_NUMBER,
	DBMSG_SET_CURRENT_RAT_NUMBER,

	// Database exporting etc.
	DBMSG_DATABASE_EXPORT,
	DBMSG_DATABASE_IMPORT,
	DBMSG_SET_DUMPFILE,

	// RG 11-9-2000
	DBMSG_GET_N_RATS,
	DBMSG_SET_N_RATS,

	// RG 11-10-2000
	DBMSG_DB_SAVE,
	DBMSG_DB_LOAD

};

//class Database;

class DatabaseMessage : public Message {
	public:
		// CGP, 12/16/00. Changing the Database * argument of the constructor
		// to a BLooper temporarily, until we change over to using purely
		// PortableMessage and PortMessage based messaging for everything
		// but the GUI portion of the system.
		DatabaseMessage(BLooper *db) {this->db = db;}
		int Ver() {return DBMSG_API_VERSION;} // return API version
		
		void Save(); // save database contents to the current experiment file
		
		// RG 11-9-2000
		int GetNumberOfRats();
		void SetNumberOfRats(int n);

		// RG 11-10-2000
		void DBSave(BFile *);
		void DBLoad(BFile *);

		// Plugin settings related messages
		BMessage *GetRatSettings();
		void SetRatSettings (BMessage *settings);
		
		// Consists of a collection of named fields. E.g., NUMBER_OF_MAZE_ARMS
		// (see PluginSettingsNames.h) is an int16 giving the number of maze arms.
		BMessage *GetExperimenterSettings();
		
		// Saves settings in the database.
		void SetExperimenterSettings(BMessage *settings); // caller retains ownership of message
		
		// Settings for performance monitor
		BMessage *GetPerfMonSettings();
		void SetPerfMonSettings(BMessage *settings);
		
		// Performance data related messages
		void AddRecord(BMessage *record);
		
		// Query the performance database and find out the number of records
		// matching the condition. Only equality constraints right now.
		// E.g.,
		//		condition.AddInt16("RecType", 1);
		//		condition.AddInt16("RatNumber", 4);
		// returns the number of records in the performance database that have
		// record type 1, for rat number 4.
		int GetNumberOfRecords(BMessage *condition);
		
		// Experimenter needs to set the current rat number so that other
		// system components can get it.
		int GetCurrentRatNumber();
		void SetCurrentRatNumber(int ratNo);
		
		// see Plugins.h for plugin types
		void SetPluginName(char *PluginType, char *Name);
		const char *GetPluginName(char *PluginType);
		
		// export/import comma delim acsii of perf mon
		void DBExport();
		void DBImport();
		void SetDumpFile(const char *filename);
		
	private: // data members
		BLooper *db;
};

//#include "Database.h"

#endif
